<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Events extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('event_id', 'name', 'production_name', 'city', 'venue', 'event_date', 'ct_event_date', 'data', 'is_active');

    public function getTickets()
    {
        return $this->hasMany('Tickets', 'event_id');
    }

}